/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.tileentity;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.WeakHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.blay09.mods.waystones.api.IAttunementItem;
import net.blay09.mods.waystones.api.IMutableWaystone;
import net.blay09.mods.waystones.api.IWaystone;
import net.blay09.mods.waystones.block.WarpPlateBlock;
import net.blay09.mods.waystones.container.WarpPlateContainer;
import net.blay09.mods.waystones.core.PlayerWaystoneManager;
import net.blay09.mods.waystones.core.WarpMode;
import net.blay09.mods.waystones.core.Waystone;
import net.blay09.mods.waystones.core.WaystoneSyncManager;
import net.blay09.mods.waystones.core.WaystoneTypes;
import net.blay09.mods.waystones.item.AttunedShardItem;
import net.blay09.mods.waystones.item.ModItems;
import net.blay09.mods.waystones.tileentity.ModTileEntities;
import net.blay09.mods.waystones.tileentity.WaystoneTileEntityBase;
import net.blay09.mods.waystones.worldgen.namegen.NameGenerationMode;
import net.blay09.mods.waystones.worldgen.namegen.NameGenerator;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IntReferenceHolder;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IServerWorld;
import net.minecraftforge.items.ItemStackHandler;

public class WarpPlateTileEntity
extends WaystoneTileEntityBase
implements ITickableTileEntity {
    private final WeakHashMap<Entity, Integer> ticksPassedPerEntity = new WeakHashMap();
    private final ItemStackHandler itemStackHandler = new ItemStackHandler(5){

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (!WarpPlateTileEntity.this.completedFirstAttunement) {
                return ItemStack.field_190927_a;
            }
            return super.extractItem(slot, amount, simulate);
        }

        protected void onContentsChanged(int slot) {
            WarpPlateTileEntity.this.func_70296_d();
        }
    };
    private final Random random = new Random();
    private final IntReferenceHolder attunementTicks = IntReferenceHolder.func_221492_a();
    private boolean readyForAttunement;
    private boolean completedFirstAttunement;
    private int lastAttunementSlot;

    public WarpPlateTileEntity() {
        super(ModTileEntities.warpPlate);
    }

    @Override
    public void initializeFromExisting(IServerWorld world, Waystone existingWaystone, ItemStack itemStack) {
        super.initializeFromExisting(world, existingWaystone, itemStack);
        CompoundNBT tag = itemStack.func_77978_p();
        boolean bl = this.completedFirstAttunement = tag != null && tag.func_74767_n("CompletedFirstAttunement");
        if (!this.completedFirstAttunement) {
            this.initializeInventory();
        }
    }

    @Override
    public void initializeWaystone(IServerWorld world, @Nullable LivingEntity player, boolean wasGenerated) {
        super.initializeWaystone(world, player, wasGenerated);
        IWaystone waystone = this.getWaystone();
        if (waystone instanceof IMutableWaystone) {
            String name = NameGenerator.get().getName(waystone, world.func_201674_k(), NameGenerationMode.RANDOM_ONLY);
            ((IMutableWaystone)((Object)waystone)).setName(name);
        }
        WaystoneSyncManager.sendWaystoneUpdateToAll(waystone);
        this.initializeInventory();
    }

    private void initializeInventory() {
        this.itemStackHandler.setStackInSlot(0, new ItemStack((IItemProvider)Items.field_151145_ak));
        this.itemStackHandler.setStackInSlot(1, new ItemStack((IItemProvider)ModItems.warpDust));
        this.itemStackHandler.setStackInSlot(2, new ItemStack((IItemProvider)ModItems.warpDust));
        this.itemStackHandler.setStackInSlot(3, new ItemStack((IItemProvider)ModItems.warpDust));
        this.itemStackHandler.setStackInSlot(4, new ItemStack((IItemProvider)ModItems.warpDust));
    }

    @Override
    protected ResourceLocation getWaystoneType() {
        return WaystoneTypes.WARP_PLATE;
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tagCompound) {
        super.func_189515_b(tagCompound);
        tagCompound.func_218657_a("Items", (INBT)this.itemStackHandler.serializeNBT());
        tagCompound.func_74757_a("ReadyForAttunement", this.readyForAttunement);
        tagCompound.func_74757_a("CompletedFirstAttunement", this.completedFirstAttunement);
        tagCompound.func_74768_a("LastAttunementSlot", this.lastAttunementSlot);
        return tagCompound;
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT tagCompound) {
        super.func_230337_a_(state, tagCompound);
        this.itemStackHandler.deserializeNBT(tagCompound.func_74775_l("Items"));
        this.readyForAttunement = tagCompound.func_74767_n("ReadyForAttunement");
        this.completedFirstAttunement = tagCompound.func_74767_n("CompletedFirstAttunement");
        this.lastAttunementSlot = tagCompound.func_74762_e("LastAttunementSlot");
    }

    @Override
    public INamedContainerProvider getWaystoneSelectionContainerProvider() {
        return new INamedContainerProvider(){

            public ITextComponent func_145748_c_() {
                return new TranslationTextComponent("container.waystones.warp_plate");
            }

            public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
                return new WarpPlateContainer(i, WarpPlateTileEntity.this, playerInventory);
            }
        };
    }

    @Override
    public INamedContainerProvider getWaystoneSettingsContainerProvider() {
        return null;
    }

    public void onEntityCollision(Entity entity) {
        Integer ticksPassed = this.ticksPassedPerEntity.putIfAbsent(entity, 0);
        if (ticksPassed == null || ticksPassed != -1) {
            this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)this.func_195044_w().func_206870_a((Property)WarpPlateBlock.ACTIVE, (Comparable)Boolean.valueOf(true)), 3);
        }
    }

    private boolean isEntityOnWarpPlate(Entity entity) {
        return entity.func_226277_ct_() >= (double)this.field_174879_c.func_177958_n() && entity.func_226277_ct_() < (double)(this.field_174879_c.func_177958_n() + 1) && entity.func_226278_cu_() >= (double)this.field_174879_c.func_177956_o() && entity.func_226278_cu_() < (double)(this.field_174879_c.func_177956_o() + 1) && entity.func_226281_cx_() >= (double)this.field_174879_c.func_177952_p() && entity.func_226281_cx_() < (double)(this.field_174879_c.func_177952_p() + 1);
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            BlockPos pos;
            AxisAlignedBB boundsAbove;
            List entities;
            if (this.isReadyForAttunement()) {
                this.attunementTicks.func_221494_a(this.attunementTicks.func_221495_b() + 1);
                if (this.attunementTicks.func_221495_b() >= this.getMaxAttunementTicks()) {
                    this.attunementTicks.func_221494_a(0);
                    ItemStack attunedShard = new ItemStack((IItemProvider)ModItems.attunedShard);
                    AttunedShardItem.setWaystoneAttunedTo(attunedShard, this.getWaystone());
                    this.itemStackHandler.setStackInSlot(0, attunedShard);
                    for (int i = 1; i <= 4; ++i) {
                        this.itemStackHandler.setStackInSlot(i, ItemStack.field_190927_a);
                    }
                    this.completedFirstAttunement = true;
                }
            } else {
                this.attunementTicks.func_221494_a(0);
            }
            if (((Boolean)this.func_195044_w().func_177229_b((Property)WarpPlateBlock.ACTIVE)).booleanValue() && (entities = this.field_145850_b.func_175674_a(null, boundsAbove = new AxisAlignedBB((double)(pos = this.func_174877_v()).func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (double)(pos.func_177958_n() + 1), (double)(pos.func_177956_o() + 1), (double)(pos.func_177952_p() + 1)), EntityPredicates.field_94557_a)).isEmpty()) {
                this.field_145850_b.func_180501_a(pos, (BlockState)this.func_195044_w().func_206870_a((Property)WarpPlateBlock.ACTIVE, (Comparable)Boolean.valueOf(false)), 3);
                this.ticksPassedPerEntity.clear();
            }
            Iterator<Map.Entry<Entity, Integer>> iterator = this.ticksPassedPerEntity.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Entity, Integer> entry = iterator.next();
                Entity entity = entry.getKey();
                Integer ticksPassed = entry.getValue();
                if (!entity.func_70089_S() || !this.isEntityOnWarpPlate(entity)) {
                    iterator.remove();
                    continue;
                }
                if (ticksPassed > 20) {
                    IWaystone targetWaystone = this.getTargetWaystone();
                    if (targetWaystone != null && targetWaystone.isValid()) {
                        this.teleportToWarpPlate(entity, targetWaystone);
                    }
                    if (entity instanceof PlayerEntity) {
                        TranslationTextComponent chatComponent;
                        if (targetWaystone == null) {
                            chatComponent = new TranslationTextComponent("chat.waystones.warp_plate_has_no_target");
                            chatComponent.func_240699_a_(TextFormatting.DARK_RED);
                            ((PlayerEntity)entity).func_146105_b((ITextComponent)chatComponent, true);
                        } else if (!targetWaystone.isValid()) {
                            chatComponent = new TranslationTextComponent("chat.waystones.warp_plate_has_invalid_target");
                            chatComponent.func_240699_a_(TextFormatting.DARK_RED);
                            ((PlayerEntity)entity).func_146105_b((ITextComponent)chatComponent, true);
                        }
                    }
                    iterator.remove();
                    continue;
                }
                if (ticksPassed == -1) continue;
                entry.setValue(ticksPassed + 1);
            }
        }
        if (this.itemStackHandler.getStackInSlot(0).func_77973_b() != Items.field_151145_ak) {
            this.completedFirstAttunement = true;
        }
    }

    private void teleportToWarpPlate(Entity entity, IWaystone targetWaystone) {
        if (PlayerWaystoneManager.tryTeleportToWaystone(entity, targetWaystone, WarpMode.WARP_PLATE, this.getWaystone())) {
            int fireSeconds = 0;
            int poisonSeconds = 0;
            int blindSeconds = 0;
            int featherFallSeconds = 0;
            int fireResistanceSeconds = 0;
            float potency = 1.0f;
            ArrayList<ItemStack> curativeItems = new ArrayList<ItemStack>();
            for (int i = 0; i < this.itemStackHandler.getSlots(); ++i) {
                ItemStack itemStack = this.itemStackHandler.getStackInSlot(i);
                if (itemStack.func_77973_b() == Items.field_151065_br) {
                    fireSeconds += 2;
                    continue;
                }
                if (itemStack.func_77973_b() == Items.field_151170_bI) {
                    poisonSeconds += 2;
                    continue;
                }
                if (itemStack.func_77973_b() == Items.field_196136_br) {
                    blindSeconds += 2;
                    continue;
                }
                if (itemStack.func_77973_b() == Items.field_151117_aB || itemStack.func_77973_b() == Items.field_226639_pY_) {
                    curativeItems.add(itemStack);
                    continue;
                }
                if (itemStack.func_77973_b() == Items.field_151045_i) {
                    potency += 1.0f;
                    continue;
                }
                if (itemStack.func_77973_b() == Items.field_151008_G) {
                    featherFallSeconds += 2;
                    continue;
                }
                if (itemStack.func_77973_b() != Items.field_151064_bs) continue;
                fireResistanceSeconds += 2;
            }
            if (entity instanceof LivingEntity) {
                if (fireSeconds > 0) {
                    entity.func_70015_d((int)((float)fireSeconds * potency));
                }
                if (poisonSeconds > 0) {
                    ((LivingEntity)entity).func_195064_c(new EffectInstance(Effects.field_76436_u, (int)((float)poisonSeconds * potency * 20.0f)));
                }
                if (blindSeconds > 0) {
                    ((LivingEntity)entity).func_195064_c(new EffectInstance(Effects.field_76440_q, (int)((float)blindSeconds * potency * 20.0f)));
                }
                if (featherFallSeconds > 0) {
                    ((LivingEntity)entity).func_195064_c(new EffectInstance(Effects.field_204839_B, (int)((float)featherFallSeconds * potency * 20.0f)));
                }
                if (fireResistanceSeconds > 0) {
                    ((LivingEntity)entity).func_195064_c(new EffectInstance(Effects.field_76426_n, (int)((float)fireResistanceSeconds * potency * 20.0f)));
                }
                for (ItemStack curativeItem : curativeItems) {
                    ((LivingEntity)entity).curePotionEffects(curativeItem);
                }
            }
        }
    }

    private boolean isReadyForAttunement() {
        return this.readyForAttunement && this.itemStackHandler.getStackInSlot(0).func_77973_b() == Items.field_151145_ak && this.itemStackHandler.getStackInSlot(1).func_77973_b() == ModItems.warpDust && this.itemStackHandler.getStackInSlot(2).func_77973_b() == ModItems.warpDust && this.itemStackHandler.getStackInSlot(3).func_77973_b() == ModItems.warpDust && this.itemStackHandler.getStackInSlot(4).func_77973_b() == ModItems.warpDust;
    }

    @Nullable
    public IWaystone getTargetWaystone() {
        boolean useRoundRobin = false;
        ArrayList<ItemStack> attunedShards = new ArrayList<ItemStack>();
        for (int i = 0; i < this.itemStackHandler.getSlots(); ++i) {
            ItemStack itemStack = this.itemStackHandler.getStackInSlot(i);
            if (itemStack.func_77973_b() instanceof IAttunementItem) {
                IWaystone waystoneAttunedTo = ((IAttunementItem)itemStack.func_77973_b()).getWaystoneAttunedTo(itemStack);
                if (waystoneAttunedTo == null || waystoneAttunedTo.getWaystoneUid().equals(this.getWaystone().getWaystoneUid())) continue;
                attunedShards.add(itemStack);
                continue;
            }
            if (itemStack.func_77973_b() != Items.field_151128_bU) continue;
            useRoundRobin = true;
        }
        if (!attunedShards.isEmpty()) {
            this.lastAttunementSlot = (this.lastAttunementSlot + 1) % attunedShards.size();
            ItemStack itemStack = useRoundRobin ? (ItemStack)attunedShards.get(this.lastAttunementSlot) : (ItemStack)attunedShards.get(this.random.nextInt(attunedShards.size()));
            return ((IAttunementItem)itemStack.func_77973_b()).getWaystoneAttunedTo(itemStack);
        }
        return null;
    }

    public ItemStackHandler getItemStackHandler() {
        return this.itemStackHandler;
    }

    public int getMaxAttunementTicks() {
        return 30;
    }

    public IntReferenceHolder getAttunementTicks() {
        return this.attunementTicks;
    }

    public void markReadyForAttunement() {
        this.readyForAttunement = true;
    }

    public void markEntityForCooldown(Entity entity) {
        this.ticksPassedPerEntity.put(entity, -1);
    }

    public boolean isCompletedFirstAttunement() {
        return this.completedFirstAttunement;
    }
}

